/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class TdmsFileReader {
    FileChannel ch;
    ByteBuffer buf;
    long pointer;
    private static final int TDMS_SEG_LEADIN_LENGTH = 28;

    public TdmsFileReader(File tdmsFile) throws FileNotFoundException, IOException {
        this.ch = new FileInputStream(tdmsFile).getChannel();
        this.buf = this.ch.map(FileChannel.MapMode.READ_ONLY, 0L, tdmsFile.length());
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        this.ch.close();
        this.pointer = 0L;
        TdmsFileReader.setByteOrder(this.buf);
    }

    private static void setByteOrder(ByteBuffer buf) {
        if (buf.get(0) != 84 && buf.get(1) != 68 && buf.get(2) != 83 && buf.get(3) != 109) {
            throw new IllegalArgumentException("should be a TDSm flag.");
        }
        int t = 64;
        if ((buf.getInt(4) & t) == t) {
            buf.order(ByteOrder.BIG_ENDIAN);
        } else {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public TdmsSegment getNextSegment() {
        this.buf.position((int)this.pointer);
        ByteBuffer buf1 = this.buf.slice();
        buf1.order(this.buf.order());
        if (buf1.get(0) != 84 && buf1.get(1) != 68 && buf1.get(2) != 83 && buf1.get(3) != 109) {
            throw new IllegalArgumentException("should be a TDSm flag.");
        }
        if (buf1.getInt(8) != 4713) {
            throw new IllegalArgumentException("should be a version number here at byte offset 8.");
        }
        long nextPointer = this.pointer + this.buf.getLong((int)(this.pointer + 12L)) + 28L;
        long oldPointer = this.pointer;
        this.pointer = nextPointer;
        return new TdmsSegment(buf1, oldPointer);
    }

    private static String showBytes(ByteBuffer buf) {
        int i;
        StringBuilder sb = new StringBuilder("buf order is ");
        sb.append(buf.order() == ByteOrder.BIG_ENDIAN ? "bigEndian" : "littleEndian");
        sb.append("\n");
        for (i = 0; i < 28; ++i) {
            sb.append(String.format("%02d ", i));
        }
        sb.append("\n");
        for (i = 0; i < 28; ++i) {
            sb.append(String.format("%02x ", buf.get(i)));
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean hasNextSegment() {
        return this.pointer < (long)this.buf.limit();
    }

    public static class TdmsSegment {
        ByteBuffer buf;
        long offset;
        int type;
        ByteOrder byteOrder;

        public TdmsSegment(ByteBuffer buf, long offset) {
            this.buf = buf;
            this.offset = offset;
            this.type = buf.getInt(4);
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            if (this.buf.get(0) != 84 && this.buf.get(1) != 68 && this.buf.get(2) != 83 && this.buf.get(3) != 109) {
                throw new IllegalArgumentException("expected Tdmssegment lead in to start with TDSm");
            }
            this.byteOrder = buf.order();
        }

        public ByteBuffer getRawData() {
            long nextSegmentOffset = this.buf.getLong(12);
            long rawDataOffset = this.buf.getLong(20);
            if (nextSegmentOffset > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("too big for Java NIO");
            }
            if (rawDataOffset > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("too big for Java NIO");
            }
            if (rawDataOffset > nextSegmentOffset) {
                throw new IllegalArgumentException("rawDataOffset is greater than nextSegmentOffset");
            }
            this.buf.position((int)rawDataOffset);
            this.buf.limit((int)nextSegmentOffset);
            ByteBuffer sl = this.buf.slice();
            TdmsFileReader.showBytes(sl);
            sl.order(this.byteOrder);
            return sl;
        }

        public long getOffset() {
            return this.offset;
        }

        public String toString() {
            return "seg type " + this.type + " @ " + this.offset;
        }
    }
}

